<?php
    session_start();
    include '../database/db_config.php';
    include '../database/api_config.php';

    $rawInput = file_get_contents("php://input");
    $data = json_decode($rawInput, true);
    $communityID = isset($data['community_id']) ? trim($data['community_id']) : null;

    if (!preg_match('/^[\d-]{10,31}@g\.us$/', $communityID)) {
        echo json_encode(['success' => false, 'message' => 'Invalid community ID format']);
        exit;
    }

    $token = API_TOKEN;

    $activePhones = [];
    $sql = "SELECT empid, name, phone FROM contacts WHERE status = 'Active' AND phone IS NOT NULL AND phone != ''";
    $result = $conn->query($sql);
    $activePhones = [];

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $cleanPhone = preg_replace('/\D/', '', $row['phone']);

            if (!empty($cleanPhone) && strlen($cleanPhone) >= 10 && strlen($cleanPhone) <= 15) {
                if (strlen($cleanPhone) == 12 && strpos($cleanPhone, '91') === 0) {
                    $activePhones[] = $cleanPhone;
                } else {
                    $activePhones[] = '91' . $cleanPhone;
                }
            }
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to fetch active employees']);
        exit;
    }

    $communityInfoUrl = "https://gate.whapi.cloud/communities/" . urlencode($communityID);
    $ch = curl_init($communityInfoUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $token,
            'Accept' => 'application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $communityResponse = curl_exec($ch);
    if (curl_errno($ch)) {
        $curlError = curl_error($ch);
        curl_close($ch);
        echo json_encode(['success' => false, 'message' => 'cURL error: ' . $curlError]);
        exit;
    }
    curl_close($ch);

    $communityData = json_decode($communityResponse, true);
    if (!isset($communityData['participants'])) {
        echo json_encode(['success' => false, 'message' => 'Could not fetch community participants']);
        exit;
    }

    $filteredParticipants = array_filter($communityData['participants'], function($p) {
        return !in_array($p['rank'], ['creator', 'admin']);
    });

    $currentParticipants = array_map(function($p) {
        return preg_replace('/\D/', '', $p['id']);
    }, $filteredParticipants);

    $toRemove = array_filter($currentParticipants, function($phone) use ($activePhones) {
        return !in_array($phone, $activePhones);
    });

    if (empty($toRemove)) {
        echo json_encode(['success' => true, 'message' => 'No participants to remove']);
        exit;
    }

    $removeUrl = "https://gate.whapi.cloud/communities/" . urlencode($communityID) . "/participants";

    $removed = [];
    $failed = [];

    foreach ($toRemove as $participant) {
        $payload = json_encode(['participants' => [$participant]]);

        $ch = curl_init($removeUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json',
                'Accept' => 'application/json'
            ],
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $responseData = json_decode($response, true);

        if ($httpCode === 200 && isset($responseData['success']) && $responseData['success']) {
            $removed[] = $participant;
        } else {
            $failed[] = [
                'participant' => $participant,
                'response' => $response,
                'http_code' => $httpCode
            ];
        }
    }

    echo json_encode([
        'success' => true,
        'message' => 'Removed ' . count($removed) . ' participant' . (count($removed) > 1 ? 's' : '') . ' successfully',
        'removed' => $removed,
        'failed' => $failed
    ]);
exit;
