<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include '../middleware/check_login.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $community_id = $_POST['community_id'] ?? '';
    $phone = $_POST['phone'] ?? '';

    if (empty($community_id) || empty($phone)) {
        $_SESSION['error_msg'] = '❌ Missing community ID or phone.';
        header('Location: ../community/community_view_members.php');
        exit;
    }

    $cleanPhone = preg_replace('/\D/', '', $phone);

    if (strlen($cleanPhone) < 7 || strlen($cleanPhone) > 15) {
        $_SESSION['error_msg'] = "❌ Invalid phone number length.";
        header('Location: ../community/community_view_members.php');
        exit;
    }
    $participant_id = $cleanPhone;
    $payload = json_encode([
        "participants" => [$participant_id]
    ]);

    $url = "https://gate.whapi.cloud/communities/" . urlencode($community_id) . "/participants";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "DELETE",
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . API_TOKEN,
            'Content-Type: application/json',
            'Accept' => 'application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => false
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $responseData = json_decode($response, true);

    if ($http_code === 200 && isset($responseData['success']) && $responseData['success']) {
        $_SESSION['success_msg'] = "✅ Member removed successfully.";
    } else {
        $errorDetail = $responseData['error']['message'] ?? 'Unknown error';
        $_SESSION['error_msg'] = "❌ Failed to remove member. HTTP $http_code: $errorDetail";
    }

    header('Location: ../community/community_view_members.php');
    exit;
} else {
    header('Location: ../community/community_view_members.php');
    exit;
}
