<?php
include('../database/db_config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $phone = trim($_POST['phone']);
    $role = $_POST['role'] ?? 'user';
    if (!in_array($role, ['admin', 'user'])) {
        die('Invalid role selected.');
    }

    $stmt = $conn->prepare("INSERT INTO users (full_name, email, password, phone, role) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $full_name, $email, $password, $phone, $role);

    if ($stmt->execute()) {
        header("Location: ../?register=success");
        exit;
    } else {
        echo "Registration failed: " . $stmt->error;
    }
    $stmt->close();
}
?>
