<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['community_id']) || empty($_SESSION['phone'])) {
    http_response_code(400);
    echo "Invalid request or session expired.";
    exit;
}

$communityId = trim($_POST['community_id']);

if (!ctype_digit($communityId)) {
    http_response_code(422);
    echo "Community ID must be numeric.";
    exit;
}

$rawPhone = preg_replace('/\D/', '', $_SESSION['phone']);

if (strlen($rawPhone) == 10) {
    $phoneForApi = '91' . $rawPhone;
} else {
    $phoneForApi = $rawPhone;
}

$stmt = $conn->prepare("SELECT community_id FROM `communities` WHERE id = ?");
if (!$stmt) {
    http_response_code(500);
    echo "Database error: failed to prepare statement.";
    exit;
}

$stmt->bind_param("i", $communityId);
if (!$stmt->execute()) {
    http_response_code(500);
    echo "Database error: failed to execute statement.";
    exit;
}

$result = $stmt->get_result();
$community = $result->fetch_assoc();
$stmt->close();

if (!$community) {
    http_response_code(422);
    echo "Invalid community selected.";
    exit;
}

$wa_community_id = $community['community_id'];

if (!str_ends_with($wa_community_id, '@g.us')) {
    $wa_community_id .= '@g.us';
}

$payload = ['participants' => [$phoneForApi]];
$url = "https://gate.whapi.cloud/communities/" . urlencode($wa_community_id) . "/admins";

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'PATCH',
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        'Accept: application/json',
        'Authorization: Bearer ' . API_TOKEN,
        'Content-Type: application/json',
    ],
    CURLOPT_SSL_VERIFYPEER => false,
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

$data = json_decode($response, true);

if ($http_code !== 200) {
    http_response_code($http_code);
    echo "API call failed (Status $http_code): " . ($error ?: json_encode($data));
    exit;
}

if (isset($data['error'])) {
    http_response_code(500);
    echo "WhatsApp API error: " . $data['error']['message'];
    exit;
}

http_response_code(200);
echo "You have been promoted to admin in Community ID: $communityId";
exit;
