<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $group_id = $_POST['group_id'] ?? '';
    $phones_input = $_POST['phones'] ?? '';

    if (empty($group_id) || empty($phones_input)) {
        $_SESSION['error_msg'] = "Group and phone numbers are required.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $stmt = $conn->prepare("SELECT group_id FROM `groups` WHERE id = ?");
    $stmt->bind_param("i", $group_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $group = $result->fetch_assoc();
    $stmt->close();

    if (!$group) {
        $_SESSION['error_msg'] = "Invalid group selected.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $wa_group_id = $group['group_id'];
    if (!str_ends_with($wa_group_id, '@g.us')) {
        $wa_group_id .= '@g.us';
    }

    $phones = explode(',', $phones_input);
    $participants = [];

    foreach ($phones as $phone) {
        $phone = preg_replace('/\D/', '', trim($phone));
        if (strlen($phone) >= 7 && strlen($phone) <= 15) {
            $participants[] = $phone;
        }
    }

    if (empty($participants)) {
        $_SESSION['error_msg'] = "No valid phone numbers provided.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $payload = ['participants' => $participants];
    $url = "https://gate.whapi.cloud/groups/" . urlencode($wa_group_id) . "/admins";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'PATCH',
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Authorization: Bearer ' . API_TOKEN,
            'Content-Type: application/json',
        ],
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if ($http_code !== 200) {
        $_SESSION['error_msg'] = "❌ API call failed (Status $http_code): " . ($error ?: json_encode($data));
        $_SESSION['debug_response'] = $data;
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    if (isset($data['error'])) {
        $_SESSION['error_msg'] = "WhatsApp API error: " . $data['error']['message'];
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $_SESSION['success_msg'] = "✅ Selected participants have been promoted to admin successfully.";
    header("Location: " . $_SERVER['HTTP_REFERER']);
    exit;
}
?>