<?php
include '../database/db_config.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, full_name, password, role, phone FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['full_name'] = $user['full_name'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['phone'] = $user['phone'];
        $_SESSION['last_activity'] = time();
        $_SESSION['expire_time'] = 7200;
        header("Location: ../");
        exit;
    } else {
        $_SESSION['login_error'] = "Invalid email or password.";
        header("Location: ../login/");
        exit;
    }
    $stmt->close();
}
?>
