<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'middleware/check_login.php';
include 'database/db_config.php'; 
include 'partials/navbar.php'; ?>
<?php
$commRes = $conn->query("SELECT community_id, community_name FROM communities ORDER BY community_name");
$communities = [];
while ($c = $commRes->fetch_assoc()) {
    $communities[$c['community_id']] = $c['community_name'];
}
$limitOptions = [10, 50, 100, 500, 1000];
$limit = (isset($_GET['limit']) && in_array((int)$_GET['limit'], $limitOptions)) ? (int)$_GET['limit'] : 10;
$page = isset($_GET['page']) ? max((int)$_GET['page'], 1) : 1;
$offset = ($page - 1) * $limit;


$columns = ['status','Member_Type','Employment_Status','Team_Name','Role','Department'];

$distinct = [];
foreach ($columns as $col) {
    $res = $conn->query("SELECT DISTINCT `$col` FROM contacts WHERE `$col` IS NOT NULL AND `$col` != '' ORDER BY `$col`");
    $distinct[$col] = [];
    while ($row = $res->fetch_assoc()) {
        $distinct[$col][] = $row[$col];
    }
}

$filters = [];
foreach ($columns as $col) {
    $vals = $_GET[$col] ?? [];
    if (!is_array($vals)) $vals = $vals === '' ? [] : [$vals];
    $filters[$col] = array_filter($vals, function($v){ return $v !== ''; });
}

$whereClauses = [];
foreach ($filters as $col => $vals) {
    if (count($vals) > 0) {
        $esc = array_map(function($v) use ($conn){ return "'" . $conn->real_escape_string($v) . "'"; }, $vals);
        $whereClauses[] = "`$col` IN (" . implode(',', $esc) . ")";
    }
}
$whereSQL = $whereClauses ? 'WHERE ' . implode(' AND ', $whereClauses) : '';

$totalRes = $conn->query("SELECT COUNT(*) as total FROM contacts $whereSQL");
$totalRows = $totalRes->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);
$sql = "SELECT id, empid, name, phone, status, Member_Type, Employment_Status, Team_Name, Role, Department 
        FROM contacts $whereSQL ORDER BY id DESC LIMIT $offset, $limit";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Contacts Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body { min-height: 100vh; background: #f8f9fa; }
    .filter-list { max-height: 180px; overflow-y: auto; border: 1px solid #dee2e6; padding: 8px; background: #fff; border-radius: 4px; }
    .filter-form fieldset { margin-bottom: 1rem; }
    .table-responsive { max-height: 500px; overflow-y: auto; }
    thead th { position: sticky; top: 0; background: white; z-index: 10; }
    .pagination { justify-content: center; }
    tr.table-danger > * {
          --bs-table-bg-type: rgba(255, 0, 21, 0.92) !important;
          --bs-table-color-type: white !important;
          background-color: var(--bs-table-bg-type) !important;
          color: var(--bs-table-color-type) !important;
      }

      tr.table-warning > * {
          --bs-table-bg-type: rgb(255, 247, 0) !important; /
          --bs-table-color-type: black !important;
          background-color: var(--bs-table-bg-type) !important;
          color: var(--bs-table-color-type) !important;
      }
  </style>
</head>
<body>
<div class="container py-4">
  <?php
            if (isset($_SESSION['success_msg'])) {
                echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                unset($_SESSION['success_msg']);
            }
            if (isset($_SESSION['error_msg'])) {
                echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                unset($_SESSION['error_msg']);
            }
        ?>
        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
        </div>
        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
        </div>
  <h2 class="mb-4 text-center">Contacts Dashboard</h2>

  <div class="mb-3">
    <label for="communitySelect" class="form-label fw-semibold">Select Community</label>
    <select id="communitySelect" class="form-select" aria-label="Select Community">
      <option value="">-- Choose Community --</option>
      <?php foreach ($communities as $id => $name): ?>
        <option value="<?= htmlspecialchars($id) ?>"><?= htmlspecialchars($name) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <p class="mb-3 fw-semibold">Total Records: <?= $totalRows ?></p>

  <form method="GET" class="filter-form row gx-3 gy-2 align-items-center mb-4">
    <?php foreach ($columns as $col): 
      $scroll = in_array($col, ['Team_Name','Department','Member_Type']); 
    ?>
      <fieldset class="col-12 col-md-6 col-lg-3">
        <legend class="h6 fw-semibold"><?= htmlspecialchars(str_replace('_',' ', $col)) ?></legend>
        <div class="<?= $scroll ? 'filter-list' : '' ?>">
          <?php foreach ($distinct[$col] as $val): ?>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="<?= $col . '_' . htmlspecialchars($val) ?>" name="<?= $col ?>[]" value="<?= htmlspecialchars($val) ?>" <?= in_array($val, $filters[$col]) ? 'checked' : '' ?> />
              <label class="form-check-label" for="<?= $col . '_' . htmlspecialchars($val) ?>"><?= htmlspecialchars($val) ?></label>
            </div>
          <?php endforeach; ?>
        </div>
      </fieldset>
    <?php endforeach; ?>

    <div class="col-12 col-md-4 col-lg-3 d-flex align-items-center gap-2">
      <label for="limitSelect" class="form-label mb-0 fw-semibold">Rows per page:</label>
      <select id="limitSelect" name="limit" class="form-select">
        <?php foreach ($limitOptions as $opt): ?>
          <option value="<?= $opt ?>" <?= $limit == $opt ? 'selected' : '' ?>><?= $opt ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <input type="hidden" name="page" value="1" />
    <div class="col-12">
      <button type="submit" class="btn btn-primary mt-3">Apply Filters</button>
    </div>
  </form>

  <form id="membersForm" class="mb-3">
    <div class="table-responsive border rounded bg-white shadow-sm">
      <table class="table table-hover table-striped align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th scope="col" style="width: 40px;">
              <input type="checkbox" id="selectAll" aria-label="Select all members" />
            </th>
            <th scope="col">EmpID</th>
            <th scope="col">Name</th>
            <th scope="col">Phone</th>
            <th scope="col">Status</th>
            <th scope="col">Member Type</th>
            <th scope="col">Employment Status</th>
            <th scope="col">Team Name</th>
            <th scope="col">Role</th>
            <th scope="col">Department</th>
          </tr>
        </thead>
        <tbody>
         <?php if ($result && $result->num_rows): ?>
    <?php 
    $rows = [];
    $phoneCounts = [];

    while ($r = $result->fetch_assoc()) {
        $phone = preg_replace('/\D/', '', $r['phone']);
        $rows[] = $r;
        if ($phone !== '') {
            $phoneCounts[$phone] = ($phoneCounts[$phone] ?? 0) + 1;
        }
    }
    ?>

    <?php foreach ($rows as $row): 
        $cleanPhone = preg_replace('/\D/', '', $row['phone']);
        $isDuplicate = $phoneCounts[$cleanPhone] > 1;
        $isShort = strlen($cleanPhone) < 10;

        $rowClass = '';
        $tooltip = '';

        if ($isShort) {
            $rowClass = 'table-warning';
            $tooltip = 'Phone number less than 10 digits';
        } elseif ($isDuplicate) {
            $rowClass = 'table-danger';
            $tooltip = 'Duplicate phone number';
        }
    ?>
        <tr class="<?= $rowClass ?>" title="<?= $tooltip ?>">
            <td>
                <input type="checkbox" class="contact-checkbox" 
                    data-empid="<?= htmlspecialchars($row['empid']) ?>" 
                    data-phone="<?= htmlspecialchars($row['phone']) ?>" />
            </td>
            <td><?= htmlspecialchars($row['empid']) ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['phone']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><?= htmlspecialchars($row['Member_Type']) ?></td>
            <td><?= htmlspecialchars($row['Employment_Status']) ?></td>
            <td><?= htmlspecialchars($row['Team_Name']) ?></td>
            <td><?= htmlspecialchars($row['Role']) ?></td>
            <td><?= htmlspecialchars($row['Department']) ?></td>
        </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr><td colspan="10" class="text-center text-muted py-3">No records found.</td></tr>
<?php endif; ?>

          </tbody>
      </table>
    </div>
    <div class="d-flex justify-content-end mt-3">
      <button type="button" class="btn btn-warning" onclick="submitSelectedMembers()">Add Selected Members</button>
    </div>
  </form>

  <nav aria-label="Page navigation" class="d-flex justify-content-center">
    <ul class="pagination">
      <?php if ($page > 1): ?>
        <li class="page-item"><a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page'=>1])) ?>" aria-label="First">&laquo;</a></li>
        <li class="page-item"><a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page'=>$page-1])) ?>" aria-label="Previous">&lt;</a></li>
      <?php endif; ?>
      <li class="page-item disabled"><span class="page-link">Page <?= $page ?> of <?= max($totalPages,1) ?></span></li>
      <?php if ($page < $totalPages): ?>
        <li class="page-item"><a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page'=>$page+1])) ?>" aria-label="Next">&gt;</a></li>
        <li class="page-item"><a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page'=>$totalPages])) ?>" aria-label="Last">&raquo;</a></li>
      <?php endif; ?>
    </ul>
  </nav>
</div>
<script src="js/functions.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  document.getElementById('selectAll').addEventListener('change', function() {
    const checked = this.checked;
    document.querySelectorAll('input[name="empids[]"]').forEach(cb => cb.checked = checked);
  });

  function submitSelectedMembers() {
    const community = document.getElementById('communitySelect').value;
    const checkboxes = document.querySelectorAll('.contact-checkbox:checked');

    if (!community) {
      alert('Please select a community first.');
      return;
    }
    if (checkboxes.length === 0) {
      alert('Please select at least one member.');
      return;
    }

    const members = Array.from(checkboxes).map(cb => ({
      empid: cb.dataset.empid,
      phone: cb.dataset.phone
    }));

    fetch('/whatsapp/controller/add_selectedMembers_to_community.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ community_id: community, members })
    })
    .then(res => res.json())
    .then(data => {
      alert(data.message || 'Members added successfully!');
      if (data.success) location.reload();
    })
    .catch(err => alert('Error: ' + err.message));
  }
</script>
</body>
</html>
