<?php
include '../middleware/check_login.php';
include '../database/db_config.php';
include '../database/api_config.php';
include '../partials/navbar.php';

$communities = $conn->query("SELECT community_id, community_name FROM `communities` ORDER BY community_name ASC");
$members = [];
$selected_community_id = '';
$selected_community_name = '';
$error_msg = '';
$http_code = 0;
$subject_owner = '';

if (isset($_POST['community_id']) && !empty($_POST['community_id'])) {
    $selected_community_id = $_POST['community_id'];
    
    $stmt = $conn->prepare("SELECT community_name, subject_owner FROM `communities` WHERE community_id = ? LIMIT 1");
    $stmt->bind_param("s", $selected_community_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $selected_community_name = $row['community_name'];
        $subject_owner = $row['subject_owner'];
    }
    $stmt->close();

    $encoded_community_id = urlencode($selected_community_id);
    $api_url = rtrim(API_BASE_URL, '/') . "/communities/$encoded_community_id";

    $ch = curl_init($api_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . API_TOKEN
        ],
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200 && $response) {
        $data = json_decode($response, true);
        if (isset($data['participants']) && is_array($data['participants'])) {
            foreach ($data['participants'] as $participant) {
                $raw_id = $participant['id'] ?? '';
                $numeric_phone = preg_replace('/[^\d]/', '', $raw_id);
                $last10 = substr($numeric_phone, -10);
                $formatted_phone = '+91' . $last10;
                $contact_name = 'Unknown';
                $stmt = $conn->prepare("SELECT name FROM contacts WHERE RIGHT(REPLACE(phone, ' ', ''), 10) = ? LIMIT 1");
                $stmt->bind_param("s", $last10);
                $stmt->execute();
                $result = $stmt->get_result();
                if ($result && $result->num_rows > 0) {
                    $contact_name = $result->fetch_assoc()['name'];
                } elseif (!empty($participant['name'])) {
                    $contact_name = $participant['name'];
                }
                $stmt->close();

                $members[] = [
                    'name' => $contact_name,
                    'phone' => $formatted_phone,
                    'wa_id' => $numeric_phone . '@s.whatsapp.net'
                ];
            }
        }
    } else {
        $error_msg = "Failed to retrieve community members. HTTP Status Code: $http_code";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>View Community Members</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
<div class="container d-flex justify-content-center align-items-start pt-5">
    <div class="col-md-10 col-sm-12 col-lg-8">
        <?php
        if (isset($_SESSION['success_msg'])) {
            echo "<div class='alert alert-success'>" . htmlspecialchars($_SESSION['success_msg']) . "</div>";
            unset($_SESSION['success_msg']);
        }
        if (isset($_SESSION['error_msg'])) {
            echo "<div class='alert alert-danger'>" . htmlspecialchars($_SESSION['error_msg']) . "</div>";
            unset($_SESSION['error_msg']);
        }
        if (!empty($error_msg)) {
            echo "<div class='alert alert-danger'>" . htmlspecialchars($error_msg) . "</div>";
        }
        ?>
        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-info" onclick="showCommunity()">🌍 Community</button>
        </div>
        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;"></div>

        <div class="card shadow-lg rounded-4">
            <div class="card-header bg-info text-white text-center rounded-top-4">
                <h4 class="mb-0">👥 View Community Members</h4>
            </div>
            <div class="card-body">
                <form method="POST" class="row g-3 mb-4" novalidate>
                    <div class="col-md-9">
                        <label for="community_id" class="form-label">Select Community</label>
                        <select name="community_id" id="community_id" class="form-select" required>
                            <option value="">-- Choose Community --</option>
                            <?php
                            if ($communities && $communities->num_rows > 0) {
                                $communities->data_seek(0);
                                while ($community = $communities->fetch_assoc()) {
                                    $selected = ($community['community_id'] === $selected_community_id) ? 'selected' : '';
                                    echo "<option value='" . htmlspecialchars($community['community_id']) . "' $selected>" . htmlspecialchars($community['community_name']) . "</option>";
                                }
                            } else {
                                echo "<option disabled>No communities found</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-3 d-grid">
                        <label class="invisible">Submit</label>
                        <button type="submit" class="btn btn-info text-white">🔍 View Members</button>
                    </div>
                </form>

                <?php if (!empty($selected_community_id)): ?>
                    <h5 class="mb-3">✅ Active Members in <strong><?= htmlspecialchars($selected_community_name) ?></strong></h5>
                    <?php if (count($members) > 0): ?>
                         <div class="mb-3 text-end">
                            <button class="btn btn-success btn-sm" onclick="exportToCSV()">
                                <i class="bi bi-download"></i> Export Members
                            </button>
                        </div>
                        <table id="membersTable" class="table table-striped">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                           <?php foreach ($members as $member): 
                                $raw_phone = preg_replace('/[^0-9]/', '', $member['phone']);
                                $is_owner = ($member['wa_id'] === $subject_owner);
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($member['name']) ?><?= $is_owner ? ' <strong>(Owner)</strong>' : '' ?></td>
                                <td><?= htmlspecialchars($member['phone']) ?></td>
                                <td>
                                    <?php if ($_SESSION['user_role'] === 'admin' && !$is_owner): ?>
                                        <form method="POST" action="../controller/remove_communityMember.php" onsubmit="return confirm('Remove <?= htmlspecialchars(addslashes($member['name'])) ?>?');">
                                            <input type="hidden" name="community_id" value="<?= htmlspecialchars($selected_community_id) ?>">
                                            <input type="hidden" name="phone" value="<?= $raw_phone ?>">
                                            <button type="submit" class="btn btn-sm btn-danger">Remove</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="alert alert-warning">No members found in this community.</div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        if ($('#membersTable tbody tr').length > 0) {
            $('#membersTable').DataTable({
                pageLength: 10,
                lengthChange: false,
                searching: true,
                ordering: true,
                info: true,
                autoWidth: false
            });
        }
    });

    function showGroups() {
        const container = document.getElementById('optionsContainer');
        if (container.style.display === 'block' && container.getAttribute('data-type') === 'groups') {
            container.style.display = 'none';
            return;
        }
        container.innerHTML = `
            <a href="../add_contacts.php" class="btn btn-outline-primary me-2 mb-2">➕ Add Contact</a>
            <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                <a href="../remove_contact.php" class="btn btn-outline-danger me-2 mb-2">❌ Remove Contact</a>
                <a href="../make_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Admin</a>
            <?php endif; ?>
            <a href="../view_group_members.php" class="btn btn-outline-info">👥 View Group Members</a>
        `;
        container.setAttribute('data-type', 'groups');
        container.style.display = 'block';
        toggleButtons('groups');
    }

    function showCommunity() {
        const container = document.getElementById('optionsContainer');
        if (container.style.display === 'block' && container.getAttribute('data-type') === 'community') {
            container.style.display = 'none';
            return;
        }
        container.innerHTML = `
            <a href="community_create.php" class="btn btn-outline-info me-2 mb-2">🔧 Create Community</a>
            <a href="community_manage.php" class="btn btn-outline-warning me-2 mb-2">⚙️ Manage Community</a>
            <a href="community_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Community Admin</a>
            <a href="community_view_members.php" class="btn btn-outline-success">👥 View Community Members</a>
        `;
        container.setAttribute('data-type', 'community');
        container.style.display = 'block';
        toggleButtons('community');
    }

    function toggleButtons(type) {
        const gBtn = document.getElementById('groupsButton');
        const cBtn = document.getElementById('communityButton');
        if (type === 'groups') {
            gBtn.classList.replace('btn-outline-secondary', 'btn-outline-primary');
            cBtn.classList.replace('btn-outline-info', 'btn-outline-secondary');
        } else {
            cBtn.classList.replace('btn-outline-secondary', 'btn-outline-info');
            gBtn.classList.replace('btn-outline-primary', 'btn-outline-secondary');
        }
    }
</script>
<script>
function exportToCSV() {
    let csv = "Name,Phone\n";
    const rows = document.querySelectorAll("#membersTable tbody tr");
    rows.forEach(row => {
        const cols = row.querySelectorAll("td");
        const name = cols[0]?.innerText.trim();
        const phone = cols[1]?.innerText.trim();

        if (name && phone) {
            csv += `"${name}","${phone}"\n`;
        }
    });
    const blob = new Blob([csv], { type: "text/csv;charset=utf-8;" });
    const link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "community_members.csv";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}
</script>
</body>
</html>
