<?php
include '../middleware/check_login.php';
include '../database/db_config.php';
include '../partials/navbar.php';
include_once __DIR__ . '/../config_filepath.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Community</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="<?= $base_url ?>/css/style.css">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
    <div class="container d-flex justify-content-center align-items-center pt-5">
        <div class="col-md-10 col-sm-12 col-lg-8">
            <?php
                if (isset($_SESSION['success_msg'])) {
                    echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                    unset($_SESSION['success_msg']);
                }
                if (isset($_SESSION['error_msg'])) {
                    echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                    unset($_SESSION['error_msg']);
                }
            ?>
            <div class="text-center mb-4">
                <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
                <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
            </div>
            <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
            </div>

            <div class="card shadow-lg rounded-4">
                <div class="card-header bg-primary text-white text-center rounded-top-4">
                    <h4 class="mb-0">🌍 Create WhatsApp Community</h4>
                </div>
                <div class="card-body">
                    <form action="../controller/create_community.php" method="POST">
                        <div class="mb-3">
                            <label for="community_name" class="form-label">Community Name</label>
                            <input type="text" class="form-control" id="community_name" name="community_name" placeholder="Enter community name..." required>
                        </div>
                        <div class="mb-3">
                            <label for="community_description" class="form-label">Description</label>
                            <textarea class="form-control" id="community_description" name="community_description" rows="3" placeholder="Enter community description..."></textarea>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Create Community</button>
                        </div>
                    </form>
                </div>
            </div>

        <div style="position: fixed; bottom: 50px; right: 20px; width: 200px; z-index: 999;">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-info text-white text-center py-2">
                    <strong class="small">📋 Existing Communities</strong>
                </div>
                <div class="card-body p-2" style="max-height: 200px; overflow-y: auto;">
                    <?php
                    $res = $conn->query("SELECT id, community_id, community_name, invite_url FROM `communities` ORDER BY id DESC");
                    if ($res && $res->num_rows > 0) {
                        echo "<ul class='list-group list-group-flush'>";
                        while ($row = $res->fetch_assoc()) {
                            $dbId = htmlspecialchars($row['id']);
                            $waCommunityId = htmlspecialchars($row['community_id']);
                            $name = htmlspecialchars($row['community_name']);
                            $inviteUrl = htmlspecialchars($row['invite_url']);
                             echo "<li class='list-group-item small py-1 px-2' style='cursor:pointer;' 
                            data-community-id='{$dbId}' 
                            data-wa-community-id='{$waCommunityId}' 
                            data-invite-url='{$inviteUrl}'
                            onclick='showInviteModal(this)'>
                            {$name}
                        </li>";
                        }
                        echo "</ul>";
                    } else {
                        echo "<p class='text-muted text-center mb-0 small'>No communities found.</p>";
                    }
                    ?>
                </div>
            </div>
        </div>
    <!-- Invite URL Modal -->
    <div class="modal fade" id="inviteUrlModal" tabindex="-1" aria-labelledby="inviteUrlModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="inviteUrlModalLabel">Community Invite URL</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="modalCommunityId">
                <input type="text" readonly class="form-control" id="inviteUrlInput" />
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="makeMeAdmin()">Make Me Admin</button>
                <button type="button" class="btn btn-primary" id="copyInviteBtn">Copy URL</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
            </div>
        </div>
    </div>
<script>
    const inviteUrlModal = new bootstrap.Modal(document.getElementById('inviteUrlModal'));

    document.addEventListener('DOMContentLoaded', function () {
        const inviteUrlInput = document.getElementById('inviteUrlInput');
        const copyInviteBtn = document.getElementById('copyInviteBtn');

        document.querySelectorAll('.community-item').forEach(function(item) {
            item.addEventListener('click', function() {
                const inviteUrl = this.getAttribute('data-invite-url');
                const communityId = this.getAttribute('data-community-id');

                if (inviteUrl && inviteUrl.trim() !== '') {
                    document.getElementById('modalCommunityId').value = communityId;
                    inviteUrlInput.value = inviteUrl;
                    inviteUrlModal.show();
                } else {
                    alert('Invite URL not available for this community.');
                }
            });
        });

        copyInviteBtn.addEventListener('click', function() {
            inviteUrlInput.select();
            inviteUrlInput.setSelectionRange(0, 99999);

            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    copyInviteBtn.innerText = 'Copied!';
                    setTimeout(() => copyInviteBtn.innerText = 'Copy URL', 2000);
                } else {
                    alert('Failed to copy URL. Please copy manually.');
                }
            } catch (err) {
                alert('Copy command not supported. Please copy manually.');
            }
        });
    });
</script>
<script>
function showGroups() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'groups') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="../add_contacts.php" class="btn btn-outline-primary me-2 mb-2">➕ Add Contact</a>
        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <a href="../remove_contact.php" class="btn btn-outline-danger me-2 mb-2">❌ Remove Contact</a>
            <a href="../make_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Admin</a>
        <?php endif; ?>
        <a href="../view_group_members.php" class="btn btn-outline-info">👥 View Group Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'groups');
    optionsContainer.style.display = 'block'; 

    document.getElementById('communityButton').classList.remove('btn-outline-secondary');
    document.getElementById('communityButton').classList.add('btn-outline-primary');
    document.getElementById('groupsButton').classList.remove('btn-outline-primary');
    document.getElementById('groupsButton').classList.add('btn-outline-secondary');
}

function showCommunity() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'community') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="community_create.php" class="btn btn-outline-info me-2 mb-2">🔧 Create Community</a>
        <a href="community_manage.php" class="btn btn-outline-warning me-2 mb-2">⚙️ Manage Community</a>
        <a href="community_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Community Admin</a>
        <a href="community_view_members.php" class="btn btn-outline-success">👥 View Community Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'community');
    optionsContainer.style.display = 'block';

    document.getElementById('communityButton').classList.remove('btn-outline-primary');
    document.getElementById('communityButton').classList.add('btn-outline-info');
    document.getElementById('groupsButton').classList.remove('btn-outline-secondary');
    document.getElementById('groupsButton').classList.add('btn-outline-primary');
}
  function showInviteModal(element) {
    var communityId = element.getAttribute('data-community-id');
    var inviteUrl = element.getAttribute('data-invite-url');
    document.getElementById('modalCommunityId').value = communityId;
    document.getElementById('inviteUrlInput').value = inviteUrl;
    inviteUrlModal.show();
}
function makeMeAdmin() {
    const communityId = document.getElementById('modalCommunityId').value;
    console.log("communityId to send:", communityId);

    if (!communityId) {
        alert("❌ Community ID missing!");
        return;
    }

    fetch('/whatsapp/controller/make_community_admin.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'community_id=' + encodeURIComponent(communityId)
    })
    .then(response => {
        if (!response.ok) throw new Error("HTTP " + response.status);
        return response.text();
    })
    .then(data => {
        alert(data);
    })
    .catch(error => {
        alert('Error: ' + error.message);
        console.error('Error:', error);
    });
}
</script>
</body>
</html>
