<?php
include 'middleware/check_login.php';
include 'config_filepath.php';
include 'database/db_config.php';
include 'partials/navbar.php';
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    $_SESSION['error_msg'] = "Access denied. Admins only.";
    header('Location: ' . $base_url . '/');
    exit();
}
$groups_result = $conn->query("SELECT id, group_name FROM `groups` ORDER BY group_name ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Promote to Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
    <div class="container d-flex justify-content-center align-items-center pt-5">
    <div class="col-md-10 col-sm-12 col-lg-8">
        <?php
            if (isset($_SESSION['success_msg'])) {
                echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                unset($_SESSION['success_msg']);
            }
            if (isset($_SESSION['error_msg'])) {
                echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                unset($_SESSION['error_msg']);
            }
        ?>
        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
        </div>
        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
        </div>

        <div class="card shadow-lg rounded-4">
            <div class="card-header bg-warning text-dark text-center rounded-top-4">
                <h4 class="mb-0">🔼 Promote Members to Admin</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="controller/make_admin_process.php">
                    <div class="mb-3">
                        <label for="group_id" class="form-label">Select Group</label>
                        <select class="form-select" name="group_id" id="group_id" required>
                            <option value="">-- Select Group --</option>
                            <?php while ($group = $groups_result->fetch_assoc()): ?>
                                <option value="<?= htmlspecialchars($group['id']) ?>">
                                    <?= htmlspecialchars($group['group_name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="phones" class="form-label">Phone Numbers (comma-separated)</label>
                        <textarea class="form-control" id="phones" name="phones" rows="4" placeholder="e.g. 919876543210,918765432109" required></textarea>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-warning">Promote to Admin</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script src="js/functions.js"></script>
</body>
</html>
