<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .login-box {
            /* max-width: 400px; */
            margin: auto;
            margin-top: 10vh;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            background-color: #ffffff;
        }
    </style>
</head>
<body>
<!-- Small & Medium screens: vertically centered -->
<div class="container d-block d-lg-none d-flex justify-content-center align-items-center">
    <div class="row w-100">
        <div class="col-sm-12 col-md-10 col-lg-6 mx-auto">
            <div class="login-box p-4 border rounded bg-light shadow">
                <h3 class="text-center mb-4">🔐 Login</h3>
                <form action="../controller/login_process.php" method="POST">
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Enter your password" required>
                    </div>
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success">Login</button>
                    </div>
                    <p class="mt-3 text-center">Don't have an account? <a href="../register/">Register</a></p>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Large & XL screens: normal top-aligned -->
<div class="container d-none d-lg-block">
    <div class="row justify-content-center">
        <div class="col-sm-12 col-md-10 col-lg-6">
            <div class="login-box p-4 border rounded bg-light shadow">
                <h3 class="text-center mb-4">🔐 Login</h3>
                <form action="../controller/login_process.php" method="POST">
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Enter your password" required>
                    </div>
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success">Login</button>
                    </div>
                    <!-- <p class="mt-3 text-center">Don't have an account? <a href="../register/">Register</a></p> -->
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>
