<?php
include 'middleware/check_login.php';
include 'database/db_config.php'; 
include 'partials/navbar.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Group</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
    <div class="container d-flex justify-content-center align-items-center pt-5">
    <div class="col-md-10 col-sm-12 col-lg-8">
        <?php
            if (isset($_SESSION['success_msg'])) {
                echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                unset($_SESSION['success_msg']);
            }
            if (isset($_SESSION['error_msg'])) {
                echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                unset($_SESSION['error_msg']);
            }
        ?>
        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
        </div>
        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
        </div>

        <div class="card shadow-lg rounded-4">
            <div class="card-header bg-primary text-white text-center rounded-top-4">
                <h4 class="mb-0">🚀 Create WhatsApp Group</h4>
            </div>
            <div class="card-body">
                <div class="mb-3">
                <form action=" controller/create_group.php" method="POST">
                        <label for="group_name" class="form-label">Group Name</label>
                        <input type="text" class="form-control" id="group_name" name="group_name" placeholder="Enter group name..." required>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">Create Group</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

        <div style="position: fixed; bottom: 50px; right: 20px; width: 200px; z-index: 999;">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-info text-white text-center py-2">
                    <strong class="small">📋 Existing Groups</strong>
                </div>
                <div class="card-body p-2" style="max-height: 200px; overflow-y: auto;">
           <?php
                $result = $conn->query("SELECT id, group_id, group_name, invite_code FROM `groups` ORDER BY id DESC");
                if ($result && $result->num_rows > 0) {
                    echo "<ul class='list-group list-group-flush'>";
                    while ($row = $result->fetch_assoc()) {
                        $dbId = htmlspecialchars($row['id']);
                        $waGroupId = htmlspecialchars($row['group_id']);
                        $groupName = htmlspecialchars($row['group_name']);
                        $inviteUrl = "https://chat.whatsapp.com/" . htmlspecialchars($row['invite_code']);

                        echo "<li class='list-group-item small py-1 px-2' style='cursor:pointer;' 
                            data-group-id='{$dbId}' 
                            data-wa-group-id='{$waGroupId}' 
                            data-invite-url='{$inviteUrl}' 
                            onclick='showInviteModal(this)'>
                            {$groupName}
                        </li>";
                    }
                    echo "</ul>";
                } else {
                    echo "<p class='text-muted text-center mb-0 small'>No groups found.</p>";
                }
                ?>
        </div>
    </div>
</div>
<div class="modal fade" id="inviteModal" tabindex="-1" aria-labelledby="inviteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="inviteModalLabel">Group Invite URL</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="modalGroupId">
                <input type="text" id="inviteUrlInput" class="form-control" readonly>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="makeMeAdmin()">Make Me Admin</button>
                <button type="button" class="btn btn-primary" onclick="copyInviteUrl()">Copy URL</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<script>
  var inviteModal = new bootstrap.Modal(document.getElementById('inviteModal'));

  function showInviteModal(element) {
    var url = element.getAttribute('data-invite-url');
    var input = document.getElementById('inviteUrlInput');
    input.value = url;
    inviteModal.show();
  }

  function copyInviteUrl() {
    var input = document.getElementById('inviteUrlInput');
    input.select();
    input.setSelectionRange(0, 99999);

    try {
      var successful = document.execCommand('copy');
      if(successful) {
        alert('Copied invite URL to clipboard!');
      } else {
        alert('Unable to copy. Please copy manually.');
      }
    } catch (err) {
      alert('Unsupported browser. Please copy manually.');
    }
  }
  function showInviteModal(element) {
    var groupId = element.getAttribute('data-group-id');
    var inviteUrl = element.getAttribute('data-invite-url');
    document.getElementById('modalGroupId').value = groupId;
    document.getElementById('inviteUrlInput').value = inviteUrl;
    inviteModal.show();
}
function makeMeAdmin() {
    const groupId = document.getElementById('modalGroupId').value;
    console.log("groupId to send:", groupId);

    if (!groupId) {
        alert("❌ Group ID missing!");
        return;
    }

    fetch('/whatsapp-group-manager/make_me_admin.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'group_id=' + encodeURIComponent(groupId)
    })
    .then(response => {
        if (!response.ok) throw new Error("HTTP " + response.status);
        return response.text();
    })
    .then(data => {
        alert(data);
    })
    .catch(error => {
        alert('Error: ' + error.message);
        console.error('Error:', error);
    });
}
</script>
<script src="js/functions.js"></script>
</body>
</html>
