<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['group_id'])) {
    $group_id = $_POST['group_id'];

    $stmt = $conn->prepare("SELECT group_id FROM `groups` WHERE id = ?");
    $stmt->bind_param("i", $group_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $group = $result->fetch_assoc();
    $stmt->close();

    if (!$group) {
        $_SESSION['error_msg'] = "Invalid group selected.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $wa_group_id = $group['group_id'];
    if (function_exists('str_ends_with')) {
        if (!str_ends_with($wa_group_id, '@g.us')) {
            $wa_group_id .= '@g.us';
        }
    } else {
        if (substr($wa_group_id, -5) !== '@g.us') {
            $wa_group_id .= '@g.us';
        }
    }

    $contacts = $conn->query("SELECT empid, name, phone FROM contacts WHERE status = 'Inactive' AND phone IS NOT NULL AND phone != ''");
    $numbers = [];

    while ($row = $contacts->fetch_assoc()) {
        $cleanPhone = preg_replace('/\D/', '', $row['phone']);
        if ($cleanPhone && strlen($cleanPhone) >= 10 && strlen($cleanPhone) <= 15) {
            if (strlen($cleanPhone) == 12 && strpos($cleanPhone, '91') === 0) {
                $numbers[] = $cleanPhone;
            } else {
                $numbers[] = '91' . $cleanPhone;
            }
        }
    }

    if (count($numbers) === 0) {
        $_SESSION['error_msg'] = "No inactive contacts with valid phone numbers found.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $url = "https://gate.whapi.cloud/groups/" . urlencode($wa_group_id) . "/participants";

    $successCount = 0;
    $failCount = 0;
    $failDetails = [];

    foreach ($numbers as $number) {
        $payload = json_encode(['participants' => [$number]]);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept: application/json',
            'Authorization: Bearer ' . API_TOKEN,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        $data = json_decode($response, true);

        if ($response === false) {
            $failCount++;
            $failDetails[$number] = $error ?: 'Unknown cURL error';
        } elseif ($http_code === 200 && !empty($data['success'])) {
            $successCount++;
        } else {
            $failCount++;
            $failMsg = $data['error']['message'] ?? ($error ?: "HTTP Error Code: $http_code");
            $failDetails[$number] = $failMsg;
        }
    }

    $_SESSION['success_msg'] = "Inactive contacts removal complete. ✅ Removed: $successCount ❌ Failed: $failCount";

    if ($failCount > 0) {
        $_SESSION['error_details'] = $failDetails;
    }

    header("Location: " . $_SERVER['HTTP_REFERER']);
    exit;
}
?>
