<?php
include '../database/db_config.php';
include '../database/api_config.php';

$communityId = $_POST['community_id'] ?? '';
if (empty($communityId)) {
    echo "<div class='text-danger'>❌ Community ID is missing.</div>";
    exit;
}

$communitiesApiUrl = rtrim(API_BASE_URL, '/') . "/communities";
$ch = curl_init($communitiesApiUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer ' . API_TOKEN,
        'Accept: application/json', 
    ],
    CURLOPT_SSL_VERIFYPEER => false,
]);
$communitiesResponse = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    echo "<div class='text-danger'>❌ Failed to fetch communities (HTTP $httpCode)</div>";
    exit;
}

$communitiesData = json_decode($communitiesResponse, true);

$targetCommunity = null;
foreach ($communitiesData['communities'] ?? [] as $community) {
    if ($community['id'] === $communityId) {
        $targetCommunity = $community;
        break;
    }
}

if (!$targetCommunity) {
    echo "<div class='text-warning'>⚠️ Community with ID <code>" . htmlspecialchars($communityId) . "</code> not found.</div>";
    exit;
}

echo "<div class='card mb-3'>";
echo "<div class='card-header bg-primary text-white'>📌 Community Info</div>";
echo "<div class='card-body'>";
echo "<p><strong>Name:</strong> " . htmlspecialchars($targetCommunity['name'] ?? 'N/A') . "</p>";
echo "<p><strong>Description:</strong> " . htmlspecialchars($targetCommunity['description'] ?? 'N/A') . "</p>";

$createdAt = $targetCommunity['created_at'] ?? null;
if ($createdAt && is_numeric($createdAt)) {
    $createdAtFormatted = date('Y-m-d H:i:s', $createdAt);
} else {
    $createdAtFormatted = htmlspecialchars($createdAt ?? 'N/A');
}

echo "<p><strong>Created At:</strong> " . $createdAtFormatted . "</p>";
echo "<p><strong>Created By:</strong> " . htmlspecialchars($targetCommunity['created_by'] ?? 'N/A') . "</p>";
echo "</div>";
echo "</div>";

$chatId = $targetCommunity['id'];
$messagesUrl = rtrim(API_BASE_URL, '/') . "/messages/list?chat_id=" . urlencode($chatId) . "&count=100";

$ch = curl_init($messagesUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer ' . API_TOKEN,
        'Accept: application/json',
    ],
    CURLOPT_SSL_VERIFYPEER => false,
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    echo "<div class='text-danger'>❌ Failed to fetch messages (HTTP $httpCode)</div>";
    exit;
}

$decoded = json_decode($response, true);
$messagesData = $decoded['messages'] ?? $decoded['data'] ?? [];

if (empty($messagesData)) {
    echo "<div class='text-warning'>⚠️ No messages found in this community.</div>";
    exit;
}

echo "<h5>📨 Recent Messages</h5>";
echo "<pre>";
print_r($messagesData);
echo "</pre>";
echo "<ul class='list-group'>";
foreach ($messagesData as $msg) {
    if (
        isset($msg['type'], $msg['chat_id'], $msg['text']['body']) &&
        $msg['type'] === 'chat' &&
        $msg['chat_id'] === $chatId &&
        trim($msg['text']['body']) !== ''
    ) {
        $text = htmlspecialchars($msg['text']['body']);
        $sender = htmlspecialchars($msg['sender_id'] ?? 'Unknown');
        $time = htmlspecialchars($msg['timestamp'] ?? '');
        if (is_numeric($time)) {
            $time = date('Y-m-d H:i:s', $time);
        }
        echo "<li class='list-group-item'>";
        echo "<strong>From:</strong> $sender<br>";
        echo "<strong>At:</strong> $time<br>";
        echo "📩 $text";
        echo "</li>";
    }
}
echo "</ul>";
?>
