<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['community_name'])) {
    $_SESSION['error_msg'] = "Community name is required.";
    header("Location: ../community/community_create.php");
    exit();
}

$community_name = trim($_POST['community_name']);
$description = trim($_POST['community_description'] ?? '');

$payload = [
    'subject' => $community_name,
    'description' => $description
];

$create_url = rtrim(API_BASE_URL, '/') . '/communities';

$ch = curl_init($create_url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . API_TOKEN
    ],
    CURLOPT_SSL_VERIFYPEER => false,
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || ($http_code !== 200 && $http_code !== 201)) {
    $_SESSION['error_msg'] = "Community creation failed: " . htmlspecialchars($response);
    header("Location: ../community/community_create.php");
    exit();
}

$data = json_decode($response, true);

if (!isset($data['id'])) {
    $_SESSION['error_msg'] = "API response missing community ID.";
    header("Location: ../community/community_create.php");
    exit();
}

$community_id = $data['id'];
$community_name = $data['name'] ?? $community_name;
$description = $data['desc'] ?? $description;
$subject_owner = $data['subjectOwner'] ?? '';
sleep(2);

$invite_url = null;
$max_retries = 5;
$retry_delay = 2;
$retried = 0;

do {
    $community_details_url = rtrim(API_BASE_URL, '/') . '/communities/' . urlencode($community_id);

    $ch = curl_init($community_details_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . API_TOKEN,
            'Accept: application/json'
        ],
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    $details_response = curl_exec($ch);
    $details_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($details_response !== false && $details_http_code === 200) {
        $details_data = json_decode($details_response, true);

        if (isset($details_data['invite_code']) && !empty($details_data['invite_code'])) {
            $invite_code = $details_data['invite_code'];
            $invite_url = "https://chat.whatsapp.com/" . $invite_code;
            break;
        }
    }

    $retried++;
    if ($retried < $max_retries) {
        sleep($retry_delay);
    }
} while ($retried < $max_retries);

if ($invite_url === null) {
    $_SESSION['error_msg'] = "Could not retrieve invite URL after multiple attempts.";
}
$stmt = $conn->prepare("INSERT INTO communities (community_id, community_name, description, subject_owner, invite_url, created_at, updated_at) VALUES (?, ?, ?, ?, ?, NOW(), NOW())");

if (!$stmt) {
    $_SESSION['error_msg'] = "Database error: " . htmlspecialchars($conn->error);
    header("Location: ../community/community_create.php");
    exit();
}

$stmt->bind_param("sssss", $community_id, $community_name, $description, $subject_owner, $invite_url);

if (!$stmt->execute()) {
    $_SESSION['error_msg'] = "Database execution error: " . htmlspecialchars($stmt->error);
    $stmt->close();
    header("Location: ../community/community_create.php");
    exit();
}

$stmt->close();

$_SESSION['success_msg'] = "Community created successfully." . ($invite_url ? " Invite URL saved." : " But invite URL not found.");
header("Location: ../community/community_create.php");
exit();
?>
