<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

$rawInput = file_get_contents("php://input");
$data = json_decode($rawInput, true);

$communityID = isset($data['community_id']) ? trim($data['community_id']) : null;

if (!preg_match('/^[\d-]{10,31}@g\.us$/', $communityID)) {
    echo json_encode(['success' => false, 'message' => 'Invalid community ID format']);
    exit;
}

$token = API_TOKEN;
$waIDs = [];

$sql = "SELECT empid, name, phone FROM contacts WHERE Status = 'Active' AND phone IS NOT NULL AND phone != ''";
$result = $conn->query($sql);

if ($result) {
    while ($row = $result->fetch_assoc()) { 
        $cleanPhone = preg_replace('/\D/', '', $row['phone']);
        if (!empty($cleanPhone) && strlen($cleanPhone) >= 10 && strlen($cleanPhone) <= 15) {
            if (strlen($cleanPhone) == 12 && strpos($cleanPhone, '91') === 0) {
                $waIDs[] = $cleanPhone;
            } else {
                $waIDs[] = '91' . $cleanPhone;
            }
        }
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to fetch contacts']);
    exit;
}

if (empty($waIDs)) {
    echo json_encode(['success' => false, 'message' => 'No active contacts found']);
    exit;
}

$communityUrl = "https://gate.whapi.cloud/communities/" . urlencode($communityID);
$ch = curl_init($communityUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer ' . $token,
        'Accept: application/json'
    ],
    CURLOPT_SSL_VERIFYPEER => false
]);
$communityResponse = curl_exec($ch);
curl_close($ch);
$communityData = json_decode($communityResponse, true);

if (!isset($communityData['invite_code'], $communityData['participants'])) {
    echo json_encode(['success' => false, 'message' => 'Could not fetch community info']);
    exit;
}

$inviteCode = $communityData['invite_code'];
$existingMembers = array_map(function($p) {
    return preg_replace('/\D/', '', $p['id']);
}, $communityData['participants']);

$added = [];
$invited = [];
$failed = [];

foreach ($waIDs as $phone) {
    if (in_array($phone, $existingMembers)) {
        $added[] = $phone;
        continue;
    }

    $addResponse = addToCommunity($communityID, $phone, $token);

    if (
        $addResponse['success'] &&
        isset($addResponse['response']['processed']) &&
        in_array($phone, $addResponse['response']['processed'])
    ) {
        $added[] = $phone;
    } else {
        $inviteResponse = sendCommunityInvite($inviteCode, $phone, $token);
        if ($inviteResponse['success']) {
            $invited[] = $phone;
        } else {
            $failed[] = $phone;
        }
    }
}

echo json_encode([
    'success' => true,
    'message' => "Community update complete: " . count($added) . " added, " . count($invited) . " invited, " . count($failed) . " failed",
    'added' => $added,
    'invited' => $invited,
    'failed' => $failed
]);

function addToCommunity($communityID, $phone, $token) {
    $url = "https://gate.whapi.cloud/communities/" . urlencode($communityID) . "/participants";
    $payload = json_encode(['participants' => [$phone]]);
    $headers = [
        'Authorization: Bearer ' . $token,
        'Accept: application/json',
        'Content-Type: application/json'
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $result = json_decode($response, true);

    return [
        'success' => ($httpCode === 200 && isset($result['success']) && $result['success'] === true),
        'response' => $result
    ];
}

function sendCommunityInvite($inviteCode, $phone, $token) {
    $url = "https://gate.whapi.cloud/groups/link/" . $inviteCode;

    $payload = json_encode([
        "to" => $phone,
        "preview_type" => "none",
       "body" => "Hi! Please reply to this message with any text to activate your community invitation link: %URL%"
    ]);

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer " . $token,
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return ["success" => false, "error" => $error];
    }

    curl_close($ch);
    $responseData = json_decode($response, true);

    if ($httpCode == 200 && (!isset($responseData['error']))) {
        return ["success" => true, "response" => $responseData];
    } else {
        return ["success" => false, "error" => $responseData];
    }
}



