<?php
include '../middleware/check_login.php';
include '../database/db_config.php';
include '../partials/navbar.php';
?>

<!DOCTYPE html>
<html>
<head>
    <title>Community Messages</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
<div class="container d-flex justify-content-center align-items-start pt-5">
    <div class="col-md-10 col-sm-12 col-lg-8">
    <h3>🌍 Communities</h3>
    <table id="communityTable" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Community Name</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $res = $conn->query("SELECT id, community_id, community_name FROM communities");
            $i = 1;
            while ($row = $res->fetch_assoc()) {
                echo "<tr>
                    <td>{$i}</td>
                    <td>" . htmlspecialchars($row['community_name']) . "</td>
                    <td><button class='btn btn-sm btn-info view-messages' data-community-id='{$row['community_id']}'>View Messages</button></td>
                </tr>";
                $i++;
            }
            ?>
        </tbody>
    </table>

    <!-- Modal -->
    <div class="modal fade" id="messagesModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Messages</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="modalMessagesContent">Loading...</div>
            </div>
        </div>
    </div>
</div>
</div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    $(document).ready(function () {
        $('#communityTable').DataTable();

        $('.view-messages').on('click', function () {
            const communityId = $(this).data('community-id');
            $('#modalMessagesContent').html("Fetching messages...");
            $('#messagesModal').modal('show');

            $.ajax({
                url: '../controller/get_community_messages.php',
                method: 'POST',
                data: { community_id: communityId },
                success: function (response) {
                    $('#modalMessagesContent').html(response);
                },
                error: function () {
                    $('#modalMessagesContent').html('<div class="alert alert-danger">Error loading messages.</div>');
                }
            });
        });

        $(document).on('click', '.delete-msg-btn', function () {
            const messageId = $(this).data('message-id');
            const communityId = $(this).data('community-id');

            if (confirm('Are you sure you want to delete this message?')) {
                $.post('../handler/delete_message.php', { message_id: messageId }, function (response) {
                    alert(response);
                    $('[data-community-id="' + communityId + '"].view-messages').click();
                });
            }
        });
    });
    </script>
</body>
</html>
