<?php
include '../middleware/check_login.php';
include '../database/db_config.php';
include '../partials/navbar.php';
include '../config_filepath.php';

$communitiesRes = $conn->query("SELECT id, community_id, community_name FROM communities ORDER BY community_name ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Manage Communities</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="<?= $base_url ?>/css/style.css">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
<div class="container d-flex justify-content-center align-items-center pt-5">
    <div class="col-md-10 col-sm-12 col-lg-10">

        <?php if (isset($_SESSION['success_msg'])): ?>
            <div class='alert alert-success'><?= $_SESSION['success_msg']; unset($_SESSION['success_msg']); ?></div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error_msg'])): ?>
            <div class='alert alert-danger'><?= $_SESSION['error_msg']; unset($_SESSION['error_msg']); ?></div>
        <?php endif; ?>

        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
        </div>

        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;"></div>

        <div class="container py-5">
            <h2 class="mb-4">Manage Community Members</h2>
           <div class="mb-4">
    <label for="communitySelector" class="form-label"><strong>Select Community:</strong></label>
    <select class="form-select" id="communitySelector">
        <?php if ($communitiesRes && $communitiesRes->num_rows > 0): ?>
            <?php while ($community = $communitiesRes->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($community['community_id']) ?>">
                    <?= htmlspecialchars($community['community_name']) ?>
                </option>
            <?php endwhile; ?>
        <?php else: ?>
            <option disabled selected>No communities found</option>
        <?php endif; ?>
    </select>
</div>
<div class="mb-4">
    <button class="btn btn-success me-2" id="addMembersBtn">➕ Add All Active Members</button>
    <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
    <button class="btn btn-danger" id="removeMembersBtn">❌ Remove All Inactive Members</button>
    <?php endif; ?>
</div>

</div>

<script>
    document.getElementById('addMembersBtn').addEventListener('click', function () {
        const btn = this;
        const communityId = document.getElementById('communitySelector').value;
        if (!communityId) return alert("Please select a community.");

        btn.disabled = true;

        fetch('../controller/add_members_to_community.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ community_id: communityId })
        })
        .then(async res => {
            const text = await res.text();
            try {
                const data = JSON.parse(text);
                alert(data.message);
                if (data.success) location.reload();
            } catch (e) {
                console.error("Invalid JSON:", text);
                alert("Server returned invalid response.");
            }
        })
        .catch(err => {
            console.error("Error adding members:", err);
            alert("Failed to add members.");
        })
        .finally(() => {
            btn.disabled = false;
        });
    });

    document.getElementById('removeMembersBtn').addEventListener('click', function () {
        const btn = this;
        const communityId = document.getElementById('communitySelector').value;
        if (!communityId) return alert("Please select a community.");

        btn.disabled = true;

        fetch('../controller/remove_members_from_community.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ community_id: communityId })
        })
        .then(async res => {
            const text = await res.text();
            try {
                const data = JSON.parse(text);
                alert(data.message);
                if (data.success) location.reload();
            } catch (e) {
                console.error("Invalid JSON:", text);
                alert("Server returned invalid response.");
            }
        })
        .catch(err => {
            console.error("Error removing members:", err);
            alert("Failed to remove members.");
        })
        .finally(() => {
            btn.disabled = false;
        });
    });
    function showGroups() {
        const container = document.getElementById('optionsContainer');
        if (container.style.display === 'block' && container.getAttribute('data-type') === 'groups') {
            container.style.display = 'none';
            return;
        }
        container.innerHTML = `
            <a href="../add_contacts.php" class="btn btn-outline-primary me-2 mb-2">➕ Add Contact</a>
            <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                <a href="../remove_contact.php" class="btn btn-outline-danger me-2 mb-2">❌ Remove Contact</a>
                <a href="../make_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Admin</a>
            <?php endif; ?>
            <a href="../view_group_members.php" class="btn btn-outline-info">👥 View Group Members</a>
        `;
        container.setAttribute('data-type', 'groups');
        container.style.display = 'block';
        toggleButtons('groups');
    }

    function showCommunity() {
        const container = document.getElementById('optionsContainer');
        if (container.style.display === 'block' && container.getAttribute('data-type') === 'community') {
            container.style.display = 'none';
            return;
        }
        container.innerHTML = `
            <a href="community_create.php" class="btn btn-outline-info me-2 mb-2">🔧 Create Community</a>
            <a href="community_manage.php" class="btn btn-outline-warning me-2 mb-2">⚙️ Manage Community</a>
            <a href="community_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Community Admin</a>
            <a href="community_view_members.php" class="btn btn-outline-success">👥 View Community Members</a>
        `;
        container.setAttribute('data-type', 'community');
        container.style.display = 'block';
        toggleButtons('community');
    }

    function toggleButtons(type) {
        const gBtn = document.getElementById('groupsButton');
        const cBtn = document.getElementById('communityButton');
        if (type === 'groups') {
            gBtn.classList.replace('btn-outline-secondary', 'btn-outline-primary');
            cBtn.classList.replace('btn-outline-info', 'btn-outline-secondary');
        } else {
            cBtn.classList.replace('btn-outline-secondary', 'btn-outline-info');
            gBtn.classList.replace('btn-outline-primary', 'btn-outline-secondary');
        }
    }
</script>
</body>
</html>
