<?php
include 'middleware/check_login.php';
include 'database/db_config.php';
include 'database/api_config.php';
include 'partials/navbar.php';

$groups = $conn->query("SELECT group_id, group_name FROM `groups` ORDER BY group_name ASC");
$members = [];
$selected_group_id = '';
$selected_group_name = '';
$error_msg = '';
$http_code = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['group_id'])) {
    $selected_group_id = $conn->real_escape_string($_POST['group_id']);

    $group_info = $conn->query("SELECT group_name FROM `groups` WHERE group_id = '$selected_group_id'");
    if ($group_info && $group_info->num_rows > 0) {
        $selected_group_name = $group_info->fetch_assoc()['group_name'];
    }

    $api_url = rtrim(API_BASE_URL, '/') . "/groups/$selected_group_id";
    $ch = curl_init($api_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . API_TOKEN
        ],
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200 && $response) {
        $data = json_decode($response, true);
        if (!empty($data['participants']) && is_array($data['participants'])) {
            foreach ($data['participants'] as $participant) {
                $raw_id = $participant['id'] ?? '';
                $numeric_phone = preg_replace('/[^\d]/', '', $raw_id);
                $last10 = substr($numeric_phone, -10);
                $contact_name = 'Unknown';

                $stmt = $conn->prepare("SELECT name FROM contacts WHERE RIGHT(REPLACE(phone, ' ', ''), 10) = ? LIMIT 1");
                $stmt->bind_param("s", $last10);
                $stmt->execute();
                $result = $stmt->get_result();
                if ($result && $result->num_rows > 0) {
                    $contact_name = $result->fetch_assoc()['name'];
                } elseif (!empty($participant['name'])) {
                    $contact_name = $participant['name'];
                }
                $stmt->close();

                $members[] = [
                    'name' => $contact_name,
                    'phone' => '+91' . $last10
                ];
            }
        }
    } else {
        $error_msg = "Failed to retrieve group members. HTTP Status Code: $http_code";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Group Members</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>
    <body class="bg-gradient vh-100 d-flex flex-column">
        <div class="container d-flex justify-content-center align-items-start pt-5">
            <div class="col-md-10 col-sm-12 col-lg-8">
            <?php
            if (isset($_SESSION['success_msg'])) {
                echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                unset($_SESSION['success_msg']);
            }
            if (isset($_SESSION['error_msg'])) {
                echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                unset($_SESSION['error_msg']);
            }
            if (!empty($error_msg)) {
                echo "<div class='alert alert-danger'>$error_msg</div>";
            }
            ?>
        <div class="text-center mb-4">
            <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
            <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
        </div>
        <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
        </div>
<div class="card shadow-lg rounded-4">
    <div class="card-header bg-info text-white text-center rounded-top-4">
        <h4 class="mb-0">👥 View Group Members</h4>
    </div>
    <div class="card-body">
        <form method="POST" class="row g-3 mb-4">
            <div class="col-md-9">
                <label for="group_id" class="form-label">Select Group</label>
                <select name="group_id" id="group_id" class="form-select" required>
                    <option value="">-- Choose Group --</option>
                    <?php
                    if ($groups && $groups->num_rows > 0) {
                        while ($group = $groups->fetch_assoc()) {
                            $selected = ($group['group_id'] === $selected_group_id) ? 'selected' : '';
                            echo "<option value='" . htmlspecialchars($group['group_id']) . "' $selected>" . htmlspecialchars($group['group_name']) . "</option>";
                        }
                    } else {
                        echo "<option disabled>No groups found</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-3 d-grid">
                <label class="invisible">Submit</label>
                <button type="submit" class="btn btn-info text-white">🔍 View Members</button>
            </div>
        </form>
        <?php if (!empty($selected_group_id)): ?>
            <h5 class="mb-3">✅ Active Members in <strong><?php echo htmlspecialchars($selected_group_name); ?></strong></h5>
            <?php if (count($members) > 0): ?>
                <div class="mb-3 text-end">
                    <button class="btn btn-success btn-sm" onclick="exportToCSV()">
                        <i class="bi bi-download"></i> Export Members
                    </button>
                </div>
                <table id="membersTable" class="table table-striped">
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($members as $member): ?>
                    <tr>
                        <td><?= htmlspecialchars($member['name']) ?></td>
                        <td><?= htmlspecialchars($member['phone']) ?></td>
                        <td>
                            <?php if ($_SESSION['user_role'] === 'admin'): ?>
                                <form method="POST" action="controller/remove_member.php" onsubmit="return confirm('Remove <?= htmlspecialchars($member['name']) ?>?');">
                                    <input type="hidden" name="group_id" value="<?= htmlspecialchars($selected_group_id) ?>">
                                    <input type="hidden" name="phone" value="<?= preg_replace('/[^0-9]/', '', $member['phone']) ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">Remove</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
                <div class="alert alert-warning">No members found in this group.</div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
</div>
</div>
<script>
  $(document).ready(function() {
    $('#membersTable').DataTable({
      "pageLength": 10,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
<script src="js/functions.js"></script>
<script>
function exportToCSV() {
    let csv = "Name,Phone\n";
    const rows = document.querySelectorAll("#membersTable tbody tr");
    rows.forEach(row => {
        const cols = row.querySelectorAll("td");
        const name = cols[0]?.innerText.trim();
        const phone = cols[1]?.innerText.trim();

        if (name && phone) {
            csv += `"${name}","${phone}"\n`;
        }
    });
    const blob = new Blob([csv], { type: "text/csv;charset=utf-8;" });
    const link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "group_members.csv";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}
</script>
</body>
</html>
