<?php
include '../middleware/check_login.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Register</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .register-box {
            /* max-width: 450px; */
            margin: auto;
            margin-top: 10vh;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            background-color: #ffffff;
        }
    </style>
</head>
<body>
    <!-- For small and medium screens -->
<div class="container d-block d-lg-none d-flex justify-content-center align-items-center">
    <div class="row w-100">
        <div class="col-sm-12 col-md-10 col-lg-6 mx-auto">
            <div class="register-box p-4 border rounded bg-light shadow">
                <h3 class="text-center mb-4">📝 Create an Account</h3>
                <form action="../controller/register_process.php" method="POST">
                    <div class="mb-3">
                        <label>Full Name</label>
                        <input type="text" name="full_name" class="form-control" placeholder="Enter your full name" required>
                    </div>
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Create a password" required>
                    </div>
                    <div class="mb-3">
                        <label>User Role</label>
                        <select name="role" class="form-select" required>
                        <option value="user" selected>User</option>
                        <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">Register</button>
                    </div>
                    <!-- <p class="mt-3 text-center">Already have an account? <a href="../login/">Login</a></p> -->
                </form>
            </div>
        </div>
    </div>
</div>

<!-- For large screens and up (default non-centered layout) -->
<div class="container d-none d-lg-block">
    <div class="row justify-content-center">
        <div class="col-sm-12 col-md-10 col-lg-6">
            <div class="register-box p-4 border rounded bg-light shadow">
                <h3 class="text-center mb-4">📝 Create an Account</h3>
                <form action="../controller/register_process.php" method="POST">
                    <div class="mb-3">
                        <label>Full Name</label>
                        <input type="text" name="full_name" class="form-control" placeholder="Enter your full name" required>
                    </div>
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" placeholder="Create a password" required>
                    </div>
                    <div class="mb-3">
                        <label>User Role</label>
                        <select name="role" class="form-select" required>
                        <option value="user" selected>User</option>
                        <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">Register</button>
                    </div>
                    <!-- <p class="mt-3 text-center">Already have an account? <a href="../login/">Login</a></p> -->
                </form>
            </div>
        </div>
    </div>
</div>

</body>
</html>
