function showGroups() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'groups') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="add_contacts.php" class="btn btn-outline-primary me-2 mb-2">➕ Add Contact</a>
        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <a href="remove_contact.php" class="btn btn-outline-danger me-2 mb-2">❌ Remove Contact</a>
            <a href="make_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Admin</a>
        <?php endif; ?>
        <a href="view_group_members.php" class="btn btn-outline-info">👥 View Group Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'groups');
    optionsContainer.style.display = 'block'; 

    document.getElementById('communityButton').classList.remove('btn-outline-secondary');
    document.getElementById('communityButton').classList.add('btn-outline-primary');
    document.getElementById('groupsButton').classList.remove('btn-outline-primary');
    document.getElementById('groupsButton').classList.add('btn-outline-secondary');
}

function showCommunity() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'community') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="community/community_create.php" class="btn btn-outline-info me-2 mb-2">🔧 Create Community</a>
        <a href="community/community_manage.php" class="btn btn-outline-warning me-2 mb-2">⚙️ Manage Community</a>
        <a href="community/community_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Community Admin</a>
        <a href="community/community_view_members.php" class="btn btn-outline-success">👥 View Community Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'community');
    optionsContainer.style.display = 'block';

    document.getElementById('communityButton').classList.remove('btn-outline-primary');
    document.getElementById('communityButton').classList.add('btn-outline-info');
    document.getElementById('groupsButton').classList.remove('btn-outline-secondary');
    document.getElementById('groupsButton').classList.add('btn-outline-primary');
}
