<?php
$messageId = $_POST['message_id'] ?? '';

if (empty($messageId)) {
    echo "❌ Invalid message ID";
    exit;
}
$apiUrl = "https://gate.whapi.cloud/delete-message";

$ch = curl_init($apiUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => http_build_query(['message_id' => $messageId]),
    CURLOPT_SSL_VERIFYPEER => false,
]);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo "❌ cURL error: " . curl_error($ch);
    curl_close($ch);
    exit;
}

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    echo "❌ Failed to delete message. HTTP Status Code: $httpCode";
    exit;
}

echo $response ?: "✅ Message deleted successfully.";
