<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['group_id'], $_POST['phone'])) {
    $group_id = trim($_POST['group_id']);
    $phone = trim($_POST['phone']);

    $api_url = rtrim(API_BASE_URL, '/') . "/groups/$group_id/participants";
    if (!defined('API_TOKEN') || empty(API_TOKEN)) {
        error_log("API_TOKEN is not defined or empty!");
        $_SESSION['error_msg'] = "❌ Server configuration error: API token missing.";
        header("Location: ../view_group_members.php");
        exit;
    }

    $payload = json_encode([
        'participants' => [$phone]
    ]);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "DELETE",
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer " . API_TOKEN,
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $response = curl_exec($ch);
    error_log("API Response: " . $response);

    if (curl_errno($ch)) {
        error_log("cURL Error: " . curl_error($ch));
    }

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    error_log("HTTP Status Code: " . $http_code);

    curl_close($ch);

    if ($http_code === 200) {
        $_SESSION['success_msg'] = "✅ Member removed successfully.";
    } else {
        $_SESSION['error_msg'] = "❌ Failed to remove member. HTTP Code: $http_code";
    }
} else {
    $_SESSION['error_msg'] = "❌ Invalid request.";
}

header("Location: ../view_group_members.php");
exit;
