<?php
include('../database/db_config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $role = $_POST['role'] ?? 'user';
    if (!in_array($role, ['admin', 'user'])) {
        die('Invalid role selected.');
    }

    $stmt = $conn->prepare("INSERT INTO users (full_name, email, password, role) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $full_name, $email, $password, $role);

    if ($stmt->execute()) {
        header("Location: ../login/index.php?register=success");
        exit;
    } else {
        echo "Registration failed: " . $stmt->error;
    }
    $stmt->close();
}
?>
