<?php
session_start();
include '../config_filepath.php';
include '../database/db_config.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['group_name'])) {
    $_SESSION['error_msg'] = "Group name is required.";
    header('Location: ' . $base_url . '/');
    exit();
}

$group_name = trim($_POST['group_name']);
$participants = [];
$result = $conn->query("
    SELECT phone
    FROM contacts
    WHERE status = 'Active'
      AND phone IS NOT NULL
      AND phone != ''
");

while ($row = $result->fetch_assoc()) {
    $cleanPhone = preg_replace('/\D/', '', $row['phone']);
    if ($cleanPhone && strlen($cleanPhone) >= 10 && strlen($cleanPhone) <= 15) {
        if (strlen($cleanPhone) == 12 && strpos($cleanPhone, '91') === 0) {
            $participants[] = $cleanPhone;
        } else {
            $participants[] = '91' . $cleanPhone;
        }
    }
}

if (count($participants) === 0) {
    die("No active employees found with valid phone numbers.");
}
$payload = [
    'subject'      => $group_name,
    'participants' => $participants
];
$create_url = rtrim(API_BASE_URL, '/') . '/groups';

$ch = curl_init($create_url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => json_encode($payload),
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . API_TOKEN
    ],
    CURLOPT_SSL_VERIFYPEER => false
]);

$response  = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

if ($http_code !== 200 || empty($data['id'])) {
    $_SESSION['error_msg'] = "Failed to create group. API response: " . print_r($data, true);
    header('Location: ' . $base_url . '/');
    exit;
}

$group_id = $data['id'];

$invite_url = rtrim(API_BASE_URL, '/') . "/groups/$group_id/invite";
$ch = curl_init($invite_url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . API_TOKEN
    ],
    CURLOPT_SSL_VERIFYPEER => false
]);
$invite_response   = curl_exec($ch);
$http_code_invite = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$invite_data = json_decode($invite_response, true);

if ($http_code_invite !== 200 || empty($invite_data['invite_code'])) {
    $_SESSION['error_msg'] = "Failed to fetch group invite code. API response: " . print_r($invite_data, true);
    header('Location: ' . $base_url . '/');
    exit;
}

$invite_code = $invite_data['invite_code'];

$stmt = $conn->prepare("INSERT INTO `groups` (group_id, group_name, invite_code) VALUES (?, ?, ?)");
if (!$stmt) {
    $_SESSION['error_msg'] = "DB error: " . $conn->error;
    header('Location: ' . $base_url . '/');
    exit;
}
$stmt->bind_param("sss", $group_id, $group_name, $invite_code);
$stmt->execute();
$stmt->close();

$_SESSION['success_msg'] = "✅ Group created successfully! Group ID: $group_id, Invite Code: $invite_code";
header('Location: ' . $base_url . '/');
exit;