<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include '../middleware/check_login.php';
include '../database/api_config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ../community_admin.php');
    exit;
}

$community_id = $_POST['community_id'] ?? '';
$phones_raw = $_POST['phones'] ?? '';

if (empty($community_id) || empty($phones_raw)) {
    $_SESSION['error_msg'] = 'Missing community ID or phone numbers.';
    header('Location: ../community/community_admin.php');
    exit;
}

if (!preg_match('/^[\d-]{10,31}@g\.us$/', $community_id)) {
    $_SESSION['error_msg'] = "Invalid Community ID format. It must be like '1234567890@g.us'.";
    header('Location: ../community/community_admin.php');
    exit;
}

$phones_array = array_filter(array_map(function($phone) {
    return preg_replace('/\D/', '', $phone);
}, explode(',', $phones_raw)));

foreach ($phones_array as $phone) {
    if (strlen($phone) < 7 || strlen($phone) > 15) {
        $_SESSION['error_msg'] = "Invalid phone number detected: $phone";
        header('Location: ../community/community_admin.php');
        exit;
    }
}

if (empty($phones_array)) {
    $_SESSION['error_msg'] = 'No valid phone numbers provided.';
    header('Location: ../community/community_admin.php');
    exit;
}

$participants = $phones_array;

$payload = json_encode([
    "participants" => $participants
]);

$url = "https://gate.whapi.cloud/communities/" . urlencode($community_id) . "/admins";

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "PATCH",
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => [
        'Authorization: Bearer ' . API_TOKEN,
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

curl_close($ch);

$responseData = json_decode($response, true);

if ($http_code === 200 && isset($responseData['success']) && $responseData['success']) {
    $_SESSION['success_msg'] = "✅ Member(s) promoted to admin successfully.";
} else {
    $errorDetail = $responseData['error']['message'] ?? $response;
    $_SESSION['error_msg'] = "❌ Failed to promote member(s). HTTP $http_code: $errorDetail";
}
header('Location: ../community/community_admin.php');
exit;
