<?php
session_start();
include '../database/db_config.php';
include '../database/api_config.php';

function addParticipantToGroup($groupID, $phoneNumber) {
    $groupID = trim($groupID);
    $url = "https://gate.whapi.cloud/groups/" . $groupID . "/participants";
    $cleanPhone = preg_replace('/\D/', '', $phoneNumber);
    $payload = json_encode(['participants' => [$cleanPhone]]);
    $headers = [
        'Accept: application/json',
        'Authorization: ' . 'Bearer ' . API_TOKEN,
        'Content-Type: application/json'
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return ['success' => false, 'error' => $error];
    }
    curl_close($ch);

    $responseData = json_decode($response, true);

    if ($httpCode === 200 && isset($responseData['success']) && $responseData['success'] === true) {
        if (!empty($responseData['processed']) && in_array($cleanPhone, $responseData['processed'])) {
            return ['success' => true, 'response' => $responseData];
        } else {
            return ['success' => false, 'reason' => 'not processed', 'response' => $responseData];
        }
    } else {
        return ['success' => false, 'http_code' => $httpCode, 'response' => $responseData];
    }
}

function sendGroupInviteLink($inviteCode, $phoneNumber) {
    $url = "https://gate.whapi.cloud/groups/link/" . $inviteCode;

    $payload = json_encode([
        "to" => $phoneNumber,
        "preview_type" => "none",
        "body" => "Hi! Please reply to this message with any text to activate your group invitation link: %URL%"
    ]);

    $headers = [
        "Accept: application/json",
        "Authorization: " . 'Bearer ' . API_TOKEN,
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return ["success" => false, "error" => $error];
    }

    curl_close($ch);
    $responseData = json_decode($response, true);

    if ($httpCode == 200 && isset($responseData['success']) && $responseData['success'] === true) {
        return ["success" => true, "response" => $responseData];
    } else {
        return ["success" => false, "error" => $responseData];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['group_id'])) {
    $group_id = (int)$_POST['group_id'];
    $stmt = $conn->prepare("SELECT group_id, invite_code FROM `groups` WHERE id = ?");
    $stmt->bind_param("i", $group_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $group = $result->fetch_assoc();
    $stmt->close();

    if (!$group) {
        $_SESSION['error_msg'] = "Invalid group selected.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $wa_group_id = $group['group_id'];
    $invite_link_full = $group['invite_code'];
    if (!$invite_link_full) {
        $_SESSION['error_msg'] = "Invite link not found.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $inviteCode = basename(parse_url($invite_link_full, PHP_URL_PATH));
    $contacts = $conn->query("SELECT phone FROM contacts WHERE status = 'Active'");
    if (!$contacts) {
        $_SESSION['error_msg'] = "Failed to fetch contacts.";
        header("Location: " . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $success = 0;
    $invited = 0;
    $failures = 0;

    while ($row = $contacts->fetch_assoc()) {
        $phone = preg_replace('/\D/', '', $row['phone']);
        if (substr($phone, 0, 2) !== '91') {
            $phone = '91' . $phone;
        }

        if (!$phone || strlen($phone) < 10 || strlen($phone) > 12) {
            continue;
        }

        try {
            $addResponse = addParticipantToGroup($wa_group_id, $phone);

            if (isset($addResponse['success']) && $addResponse['success'] === true) {
                $success++;
            } else {
                if (isset($addResponse['http_code']) && $addResponse['http_code'] === 409) {
                    $success++;
                } else {
                    $inviteResponse = sendGroupInviteLink($inviteCode, $phone);
                    if ((isset($inviteResponse['success']) && $inviteResponse['success'] === true) ||
                        (isset($inviteResponse['error']['sent']) && $inviteResponse['error']['sent'] === true)) {
                        $invited++;
                    } else {
                        $failures++;
                    }
                }
            }
        } catch (Exception $e) {
            $failures++;
        }
    }

    $_SESSION['success_msg'] = "Process completed: Added to group: $success, Invited via link: $invited, Failed: $failures";
    header("Location: " . $_SERVER['HTTP_REFERER']);
    exit;
}
?>
