<?php
include '../middleware/check_login.php';
include '../database/db_config.php';
include '../partials/navbar.php';
include_once __DIR__ . '/../config_filepath.php';

if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    $_SESSION['error_msg'] = "Access denied. Admins only.";
    header('Location: ' . $base_url . '/');
    exit();
}

$communities_result = $conn->query("SELECT id, community_id, community_name FROM `communities` ORDER BY community_name ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Promote Community Members to Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="<?= $base_url ?>/css/style.css">
</head>
<body class="bg-gradient vh-100 d-flex flex-column">
<div class="container d-flex justify-content-center align-items-center pt-5">
    <div class="col-md-10 col-sm-12 col-lg-8">
        <?php
            if (isset($_SESSION['success_msg'])) {
                echo "<div class='alert alert-success'>" . $_SESSION['success_msg'] . "</div>";
                unset($_SESSION['success_msg']);
            }
            if (isset($_SESSION['error_msg'])) {
                echo "<div class='alert alert-danger'>" . $_SESSION['error_msg'] . "</div>";
                unset($_SESSION['error_msg']);
            }
        ?>
         <div class="text-center mb-4">
                <button id="groupsButton" class="btn btn-outline-primary me-2" onclick="showGroups()">🚀 Groups</button>
                <button id="communityButton" class="btn btn-outline-secondary" onclick="showCommunity()">🌍 Community</button>
            </div>
            <div id="optionsContainer" class="text-center mb-4 nav-buttons" style="display: none;">
            </div>

        <div class="card shadow-lg rounded-4">
            <div class="card-header bg-warning text-dark text-center rounded-top-4">
                <h4 class="mb-0">🔼 Promote Community Members to Admin</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="../controller/community_make_admin_process.php" autocomplete="off">
                    <div class="mb-3">
                        <label for="community_id" class="form-label">Select Community</label>
                        <select class="form-select" name="community_id" id="community_id" required>
                            <option value="">-- Select Community --</option>
                            <?php while ($community = $communities_result->fetch_assoc()): ?>
                                <option value="<?= htmlspecialchars($community['community_id']) ?>">
                                    <?= htmlspecialchars($community['community_name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="phones" class="form-label">Phone Numbers (comma-separated)</label>
                        <textarea class="form-control" id="phones" name="phones" rows="4" placeholder="e.g. 919876543210,918765432109" required></textarea>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-warning">Promote to Admin</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
function showGroups() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'groups') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="../add_contacts.php" class="btn btn-outline-primary me-2 mb-2">➕ Add Contact</a>
        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <a href="../remove_contact.php" class="btn btn-outline-danger me-2 mb-2">❌ Remove Contact</a>
            <a href="../make_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Admin</a>
        <?php endif; ?>
        <a href="../view_group_members.php" class="btn btn-outline-info">👥 View Group Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'groups');
    optionsContainer.style.display = 'block'; 

    document.getElementById('communityButton').classList.remove('btn-outline-secondary');
    document.getElementById('communityButton').classList.add('btn-outline-primary');
    document.getElementById('groupsButton').classList.remove('btn-outline-primary');
    document.getElementById('groupsButton').classList.add('btn-outline-secondary');
}

function showCommunity() {
    var optionsContainer = document.getElementById('optionsContainer');
    if (optionsContainer.style.display === 'block' && optionsContainer.getAttribute('data-type') === 'community') {
        optionsContainer.style.display = 'none';
        return;
    }
    optionsContainer.innerHTML = `
        <a href="community_create.php" class="btn btn-outline-info me-2 mb-2">🔧 Create Community</a>
        <a href="community_manage.php" class="btn btn-outline-warning me-2 mb-2">⚙️ Manage Community</a>
        <a href="community_admin.php" class="btn btn-outline-success me-2 mb-2">👑 Make Community Admin</a>
        <a href="community_view_members.php" class="btn btn-outline-success">👥 View Community Members</a>
    `;
    optionsContainer.setAttribute('data-type', 'community');
    optionsContainer.style.display = 'block';

    document.getElementById('communityButton').classList.remove('btn-outline-primary');
    document.getElementById('communityButton').classList.add('btn-outline-info');
    document.getElementById('groupsButton').classList.remove('btn-outline-secondary');
    document.getElementById('groupsButton').classList.add('btn-outline-primary');
}
</script>
</body>
</html>
